﻿using System;

namespace CSharpBuch.Kap07
{
  class Aufgabe1
  {
    static void Main(string[] args)
    {
      ProfiRechner r2 = new ProfiRechner();
      GeoRechner gr = new GeoRechner();
      Console.WriteLine("7 + 8 = " + r2.Addition(7, 8));
      Console.WriteLine("99 - 77 = " + gr.Subtraktion(99, 77));
      Console.WriteLine("2,76 * 5,75 = " + r2.Multiplikation(2.76, 5.75));
      Console.WriteLine("4 ^ 3 = " + r2.Potenz(4, 3));
      Console.WriteLine("5! = " + r2.Fakultaet(5));
      Console.WriteLine("Rechteckumfang a = 10, b = 7 = " + gr.UmfangRecheck(10, 7));
      Console.WriteLine("Rechteckfläche a = 10, b = 7 = " + gr.FlaecheRechteck(10, 7));
      Console.WriteLine("Kreisfläche r = 2 = " + gr.FlaecheKreis(2));
      Console.ReadLine();
    }
  }

  class Rechner
  {
    public double Addition(double x, double y)
    {
      return (x + y);
    }
    public double Subtraktion(double x, double y)
    {
      return (x - y);
    }
    public double Multiplikation(double x, double y)
    {
      return (x * y);
    }
    public double Division(double x, double y)
    {
      return (x / y);
    }
  }

  class ProfiRechner : Rechner
  {
    public double Potenz(double x, int p)
    {
      if (p == 0)
        return (1.0);

      if (p < 0)
        return (0.0);

      double d = x;
      for (int i = 2; i <= p; i++)
        d = d * x;

      return (d);
    }

    public long Fakultaet(int n)
    {
      if (n < 0)
        return (0);

      if (n == 1)
        return (1);

      long d = 1;
      for (int i = 2; i <= n; i++)
        d = d * i;

      return (d);
    }
  }

  class GeoRechner : Rechner
  {
    public double FlaecheRechteck(double a, double b)
    {
      return (base.Multiplikation(a, b));
    }

    public double UmfangRecheck(double a, double b)
    {
      return (2 * base.Addition(a, b));
    }

    public double FlaecheKreis(double r)
    {
      return (3.14 * r * r);
    }
  }
}